//
//  Home.swift
//  Do It
//
//  Created by Jim Dovey on 5/20/20.
//  Copyright © 2020 Pragmatic Programmers. All rights reserved.
//

import SwiftUI

// START:ListChooserData
struct Home: View {
    // START_HIGHLIGHT
    @EnvironmentObject private var data: DataCenter
    // END_HIGHLIGHT
    
    var body: some View {
        NavigationView {
            List {
                Section {
                    // <literal:elide> all items </literal:elide>
                    // END:ListChooserData
                    NavigationLink(destination: TodoList()) {
                        Row(name: "All Items",
                            icon: "list.bullet",
                            color: .gray)
                    }
                    // START:AddEnvironentObject
                }
                
                Section {
                    // START_HIGHLIGHT
                    ForEach(defaultTodoLists) { list in
                        // END_HIGHLIGHT
                        // <literal:elide> navigation link </literal:elide>
                        // END:ListChooserData
                        NavigationLink(destination: TodoList(list: list)) {
                            Row(name: list.name,
                                icon: list.icon,
                                color: list.color.uiColor)
                        }
                        // START:ListChooserData
                    }
                }
            }
            // <literal:elide> view modifiers </literal:elide>
            // END:ListChooserData
            .font(.system(.headline, design: .rounded))
            .listStyle(GroupedListStyle())
            .navigationBarTitle("Lists")
            // START:ListChooserData
        }
    }
    
    // <literal:elide> struct Row: View { ... } </literal:elide>
    // END:ListChooserData
    private struct Row: View {
        var name: String
        var icon: String
        var color: Color
        
        var body: some View {
            HStack {
                Image(systemName: icon)
                    .foregroundColor(.white)
                    .frame(width: 32, height: 32)
                    .background(color)
                    .clipShape(Circle())
                Text(name)
            }
        }
    }
    // START:ListChooserData
}

struct Home_Previews: PreviewProvider {
    static var previews: some View {
        Home()
        // START_HIGHLIGHT
            .environmentObject(DataCenter())
        // END_HIGHLIGHT
    }
}
// END:ListChooserData
